using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.IO;

public partial class Upload_file : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        // No code here yet.
    }

    protected void BtnUploadFile_Click(object sender, EventArgs e)
    {
        // This code gets the filename in the "FileUpload" textbox when the user has clicked the
        // "btnUploadFile" button and saves this file to the "files" folder on the webserver with 
        // the same name as the original filename. Note that you need to have the "files" folder to be able 
        // to save the file.

        // The Try/Catch/Finally block is used to handle exceptions.
        try
        {
            if (FileUpload.PostedFile != null)
            {
                // Get the file name of the uploaded file.
                string FileName = Path.GetFileName(FileUpload.PostedFile.FileName);

                // Save the file on the web server
                FileUpload.PostedFile.SaveAs(Server.MapPath("files/") + FileName);

                // Print a message.
                Message.Text = "Your file has been uploaded successfully";
            }
            else
            {
                throw new Exception();
            }
        }
        catch (Exception ex)
        {
            Message.Text = "The file could not be uploaded, the errormessage is: " + ex.ToString();
        }

    }

    protected void btnShowList_Click(object sender, EventArgs e)
    {
        
        // This code looks in the "files" folder on the webserver when the user has clicked a button and
        // then gets the names on all the files in this folder. The name on the files are presented
        // as LinkButtons in the repeater with the name "FilesRepeater".

        // Declare a variable for the folder that contains files.
        DirectoryInfo FilesInFolder = new DirectoryInfo(Server.MapPath("files/"));

        // Get all the files from the folder and bind data to the Repeater control.
        FilesRepeater.DataSource = FilesInFolder.GetFiles("*");
        FilesRepeater.DataBind();

    }

    protected void DownLoadLinkButton_Click(object sender, CommandEventArgs e)
    {
        // When the user has clicked a LinkButton for a file we get the name of the file by a
        // CommandArgument and then uses this name to make it possible for the user to download
        // the file.

        // The Try/Catch/Finally block is used to handle exceptions.
        try
        {
            // Set the file path as a string.
            string FileName = "files/" + (e.CommandArgument).ToString();

            // Set the file path as a new FileInfo object.
            FileInfo LookForFile = new FileInfo(Server.MapPath(FileName));

            if (LookForFile.Exists)
            {
                // Give the user a Save As Dialog to download the text file. The term "octet-stream" means 
                // that the file could be of any type with any extension.

                Response.Clear();
                Response.ContentType = ("application/octet-stream");
                Response.AppendHeader("Content-Disposition", "attachment; filename=" + (e.CommandArgument).ToString());
                Response.WriteFile(Server.MapPath(FileName));
                Response.Flush();
                Response.Close();
            }
            else
            {
                throw new FileNotFoundException();
            }
        }
        catch (FileNotFoundException ex)
        {
            Message2.Text = "The file could not be downloaded, the errormessage is: " + ex.ToString();
        }
        finally
        {
        }
    }
}
